package cn.com.duiba.quanyi.center.api.dto.settlement.stat;

import lombok.Data;

import java.io.Serializable;

/**
 * 结算订单统计-日纬度
 * @author mybatis generator
 * @date 2024-11-26
 */
@Data
public class SettlementOrderStatDayFillDto implements Serializable {

    private static final long serialVersionUID = 17325899993232412L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 结算单ID-开票
     */
    private Long settlementId;

    /**
     * 结算金额
     */
    private Long settlementAmount;

    /**
     * 已开票金额
     */
    private Long invoicedAmount;

    /**
     * 格式：发票ID_0_金额，发票ID_0_金额
     */
    private String invoiceIds;

    /**
     * 已回款金额
     */
    private Long receivedAmount;

    /**
     * 格式：发票ID_回款ID_金额,发票ID_回款ID_金额
     */
    private String receiveIds;

    /**
     * 格式：refId_金额,refId_金额
     * tb_settlement_stat_task_ref.id
     */
    private String refIds;
}
