package cn.com.duiba.quanyi.center.api.remoteservice.activity.take;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.UserTakeStatCacheDto;

import java.util.List;

/**
 * 用户领取记录统计
 * @author kjj mybatis generator
 * @date 2025-04-21
 */
@AdvancedFeignClient
public interface RemoteUserTakeStatService {

    /**
     * 根据用户及活动查询
     * @param userId 用户ID
     * @param activityId 活动ID
     * @return 用户领取记录统计
     */
    List<UserTakeStatCacheDto> selectByUserActCache(Long userId, Long activityId);

    /**
     * 根据用户及集合页查询（自动获取维度配置）
     * @param userId 用户ID
     * @param collectionPageId 集合页ID
     * @return 用户领取记录统计
     */
    UserTakeStatCacheDto selectByUserCollectionPageCache(Long userId, Long collectionPageId);

    /**
     * 初始化用户领取记录统计
     * @param userId 用户ID
     * @param activityId 活动ID
     * @param collectionPageId 集合页ID
     * @return 执行结果
     */
    int initUserStatActivity(Long userId, Long activityId, Long collectionPageId);
}
