package cn.com.duiba.quanyi.center.api.enums.task;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 定时任务循环类型：1-每天，2-每周，3-每月
 * @author lfh
 */
@Getter
@AllArgsConstructor
public enum ScheduledTaskCycleTypeEnum {

    DAY(1, "每天"),
    WEEK(2, "每周"),
    MONTH(3, "每月")
    ;


    private final Integer type;

    private final String desc;


    public static ScheduledTaskCycleTypeEnum getByType(Integer type) {
        for (ScheduledTaskCycleTypeEnum value : values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }
}
