package cn.com.duiba.quanyi.center.api.param.activity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum;
import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * B端-活动奖品领取记录分页查询参数
 *
 * @author yangyukang
 * @date 2024-12-20
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ActivityPrizeReceiveRecordPageParam extends PageQuery implements Serializable {
    
    private static final long serialVersionUID = -8503945362449930756L;
    
    /**
     * 活动类型
     *
     * @see BizActTypeEnum
     */
    private Integer activityType;
    
    /**
     * 活动id
     */
    private Long activityId;
    
    /**
     * 活动奖项id
     */
    private Long activityPrizeId;
    
    /**
     * 用户id
     */
    private Long userId;
    
    /**
     * 周期的开始时间
     */
    private Date beginDate;
    
    /**
     * 周期的结束时间
     */
    private Date endDate;
    
    /**
     * 用户ID集合
     */
    private List<Long> userIdList;

    /**
     * 活动ID集合
     */
    private List<Long> activityIds;
    
    /**
     * 手机号
     */
    private String userPhone;
    
    /**
     * 领取方式：1-单一领取，2-一键领取
     * @see cn.com.duiba.quanyi.center.api.enums.activity.TakeTypeEnum
     */
    private Integer takeType;
} 