package cn.com.duiba.quanyi.center.api.dto.activity.common.result.collection;

import java.util.List;

import cn.com.duiba.quanyi.center.api.dto.activity.common.result.ActivityCommonBaseUserResultDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.result.ActivityCommonCanParticipateDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 集合页用户结果DTO
 * 支持多分组、多维度的统计逻辑
 * 
 * <p>数据结构说明：</p>
 * <ul>
 *   <li>集合页级别：包含基础信息（报名、访问权限等）</li>
 *   <li>分组级别：participateLimit字段包含每个分组的统计信息</li>
 *   <li>活动级别：activityList字段包含每个活动的详细信息</li>
 * </ul>
 * 
 * <p>版本兼容说明：</p>
 * <ul>
 *   <li>旧版本：使用单一统计字段（userTakeStatId、takeCount等）</li>
 *   <li>新版本：使用participateLimit中的分组统计信息</li>
 *   <li>建议：新业务使用participateLimit，旧业务逐步迁移</li>
 * </ul>
 * 
 * @author lizhi
 * @author yangyukang
 * @date 2025/4/22 09:52
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class ActivityCommonCollectionPageUserResultDto extends ActivityCommonBaseUserResultDto {

    private static final long serialVersionUID = 3824015657716216990L;

    /**
     * 是否开启报名
     */
    private Boolean enableSignedUp;

    /**
     * 是否可参与
     */
    private ActivityCommonCanParticipateDto canParticipate;

    /**
     * 用户领取统计数据表ID
     * @deprecated 建议使用participateLimit中的userTakeStatId，支持多分组场景
     * 该字段仅在单分组或无分组场景下使用，多分组场景下可能不准确
     */
    @Deprecated
    private Long userTakeStatId;

    /**
     * 活动维度已领取数量，用于校验领取记录并发写入
     * @deprecated 建议使用participateLimit中的takeCount，支持多分组多维度场景
     * 该字段仅表示单一维度的统计，无法区分不同分组和周期
     */
    @Deprecated
    private Long takeCount;

    /**
     * 最后一次领取记录ID，用于校验领取记录并发写入
     * @deprecated 建议使用participateLimit中的lastRecordId，支持多分组场景
     * 该字段仅表示单一维度的统计，无法区分不同分组和周期
     */
    @Deprecated
    private Long lastRecordId;

    /**
     * 已参与的活动ID，下划线分割
     * @deprecated 建议使用participateLimit中的takeActivityIds，支持多分组场景
     * 该字段仅表示单一维度的统计，无法区分不同分组和周期
     */
    @Deprecated
    private String takeActivityIds;

    /**
     * 已参与的活动ID列表
     * @deprecated 建议使用participateLimit中的participateActivityIds，支持多分组场景
     * 该字段仅表示单一维度的统计，无法区分不同分组和周期
     */
    @Deprecated
    private List<Long> participateActivityIds;

    /**
     * 参与限制（分组维度统计列表）
     * 
     * <p>说明：</p>
     * <ul>
     *   <li>每个元素代表一个分组的统计信息</li>
     *   <li>包含分组配置（groupId、dimension、participateNum等）</li>
     *   <li>包含用户在该分组维度下的统计数据（takeCount、takeActivityIds等）</li>
     *   <li>支持不同分组使用不同的维度周期（永久、日、周、月、季度、自定义）</li>
     * </ul>
     * 
     * <p>使用示例：</p>
     * <pre>
     * // 遍历所有分组，检查用户参与情况
     * for (ActivityCommonParticipateLimitResultDto limit : participateLimit) {
     *     Long groupId = limit.getGroupId();
     *     Integer dimension = limit.getDimension();
     *     String period = limit.getDimensionPeriod();
     *     Long takeCount = limit.getTakeCount();
     *     Long surplus = limit.getSurplusParticipateNum();
     *     // 业务逻辑...
     * }
     * </pre>
     */
    private List<ActivityCommonParticipateLimitResultDto> participateLimit;

    /**
     * 活动列表
     * 包含集合页下所有活动的详细信息和参与状态
     */
    private List<ActivityCommonUserActivityResultDto> activityList;

}
