package cn.com.duiba.quanyi.center.api.enums.activity.common;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.hutool.core.date.DateUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Date;

/**
 * Created by dugq on 2025/12/10.
 */
@Getter
@AllArgsConstructor
public enum ActivityPaymentExpireEnum {

    ABSOLUTE(2, "绝对时间"),
    DAY(3, "当日"),
    WEEK(4, "当周"),
    MONTH(5, "当月"),
    DAYS_AFTER(7,"固定天数")
    ;

    private final Integer code;

    private final String desc;


    public static ActivityPaymentExpireEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (ActivityPaymentExpireEnum e : ActivityPaymentExpireEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

    public static Date getDeadLineDateTime(Date payDateTime,Integer expireType,Date expireDateTime,Integer expireDays) {
        if (payDateTime == null) {
            return null;
        }
        ActivityPaymentExpireEnum expireTypeEnum = getByCode(expireType);
        if (expireTypeEnum == null) {
            return null;
        }
        switch (expireTypeEnum) {
            case DAY:
                return DateUtil.endOfDay(payDateTime);
            case WEEK:
                return DateUtil.endOfWeek(payDateTime);
            case MONTH:
                return DateUtil.endOfMonth(payDateTime);
            case DAYS_AFTER:
                if (expireDays == null) {
                    return null;
                }
                return DateUtil.endOfDay(DateUtils.daysAddOrSub(payDateTime, expireDays));
            case ABSOLUTE:
                if (expireDays == null) {
                    return null;
                }
                return DateUtil.endOfDay(expireDateTime);
            default:
                return null;
        }
    }

}
