package cn.com.duiba.quanyi.center.api.param.cardsecret;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 卡密回退通知参数
 *
 * @author yangyukang
 * @date 2025-01-28
 */
@Data
public class CardSecretRefundNotifyParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 任务ID
     */
    private Long taskId;

    /**
     * 任务状态：1-待处理，2-处理中，3-已完成，4-已失败，5-已取消
     */
    private Integer status;

    /**
     * 总退回数
     */
    private Long totalRefundNum;

    /**
     * 扩展字段（透传字段）
     */
    private String ext;

    /**
     * 明细列表
     */
    private List<CardSecretRefundNotifyDetailParam> detailList;
}

