package cn.com.duiba.quanyi.center.api.param.insurance;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2024/3/5 13:55
 */
@Data
public class InsuranceTakeParam implements Serializable {

    private static final long serialVersionUID = -6648475263099236277L;

    /**
     * 保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 变更金额，单位分
     */
    private Long amount;

    /**
     * 发放信息
     */
    private InsuranceTakeGrantParam grantParam;

    /**
     * 拆分的奖品
     */
    private List<InsuranceTakeSplitParam> prizeList;

    /**
     * 任务ID
     */
    private String taskId;

    /**
     * 权益ID tb_insurance_equity.id
     */
    private Long equityId;

    /**
     * 手续费，单位分
     */
    private Long commissionAmount;

    /**
     * 提现费率
     */
    private String rateWithdrawal;

    /**
     * 实际发放金额
     * @return 实际发放金额
     */
    public long getGrantAmount() {
        if (amount == null) {
            return 0;
        }
        return amount - getCommissionAmount();
    }

    public long getCommissionAmount() {
        if (commissionAmount == null) {
            return 0;
        }
        return commissionAmount;
    }
}
