package cn.com.duiba.quanyi.center.api.enums.activity.common;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.hutool.core.date.DateUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Calendar;
import java.util.Date;

/**
 * Created by dugq on 2025/12/10.
 */
@Getter
@AllArgsConstructor
public enum ActivityPaymentExpireEnum {

    ABSOLUTE(2, "绝对时间"),
    DAY(3, "当日"),
    WEEK(4, "当周"),
    MONTH(5, "当月"),
    DAYS_AFTER(7,"固定天数")
    ;

    private final Integer code;

    private final String desc;


    public static ActivityPaymentExpireEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (ActivityPaymentExpireEnum e : ActivityPaymentExpireEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

    public static Date getDeadLineDateTime(Date payDateTime,Integer expireType,Date expireDateTime,Integer expireDays) {
        if (payDateTime == null) {
            return null;
        }
        ActivityPaymentExpireEnum expireTypeEnum = getByCode(expireType);
        if (expireTypeEnum == null) {
            return null;
        }
        switch (expireTypeEnum) {
            case DAY:
                return getEndOfDaySafe(payDateTime);
            case WEEK:
                return getEndOfDaySafe(DateUtil.endOfWeek(payDateTime));
            case MONTH:
                return getEndOfDaySafe(DateUtil.endOfMonth(payDateTime));
            case DAYS_AFTER:
                if (expireDays == null) {
                    return null;
                }
                Date dateLine = DateUtils.daysAddOrSub(payDateTime, expireDays);
                return getEndOfDaySafe(DateUtil.endOfDay(dateLine));
            case ABSOLUTE:
                if (expireDateTime == null) {
                    return null;
                }
                return getEndOfDaySafe(DateUtil.endOfDay(expireDateTime));
            default:
                return null;
        }
    }

    /**
     * 把时间重置为 yyyy-MM-DD 23:59:59 000
     * 后面的000 很重要，mysql datetime数据类型不存最后三位，采用四舍五入
     * 不重置为000 它会进一保存为第二天的0点
     */
    private static Date getEndOfDaySafe(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        cal.set(Calendar.MILLISECOND, 0);  // 关键：毫秒设为0
        return cal.getTime();
    }

}
