package cn.com.duiba.quanyi.center.api.dto.qystatistic;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 需求商品消耗统计传输对象
 *
 * @author xuzhigang
 * @date 2025-6-3
 */
@Data
public class DemandGoodsConsumeStatDto implements Serializable {

    private static final long serialVersionUID = 2847591630847592746L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 统计纬度ID，类型=1-项目ID字符串，类型=2-对接人ID字符串，以此类推
     */
    private String statId;

    /**
     * 统计纬度类型：1-项目，2-项目商品，3-对接人，4-需求，5-需求商品，6-结算单，7-微信批次号，8-支付宝批次号，9-卡密批次号，10-支付宝数币批次号，11-美团批次号，12-抖音批次号，13-外部批次号
     */
    private Integer statType;

    /**
     * 消耗金额
     */
    private Long consumeAmount;

    /**
     * 需求预算
     */
    private Long consumeBudget;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
