package cn.com.duiba.quanyi.center.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.ems.snsshop.EmsSnsShopUserExtDto;

/**
 * 用户扩展信息-邮储智慧校园
 * @author kjj mybatis generator 
 * @date 2024-05-23
 */
@AdvancedFeignClient
public interface RemoteEmsSnsShopUserExtService {

    /**
     * 根据唯一建查询用户扩展信息
     * @param phone 手机号
     * @param userType 用户类型
     * @see cn.com.duiba.quanyi.center.api.enums.user.UserTypeEnum
     * @return
     */
    EmsSnsShopUserExtDto selectByUkWithLocal(String phone, Integer userType);

    /**
     * 保存或更新
     * @param dto
     * @return
     */
    int saveOrUpdate(EmsSnsShopUserExtDto dto);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 用户扩展信息-邮储智慧校园
     */
    EmsSnsShopUserExtDto selectById(Long id);

    /**
     * 新增
     * @param dto 用户扩展信息-邮储智慧校园
     * @return 执行结果
     */
    int insert(EmsSnsShopUserExtDto dto);

    /**
     * 更新
     * @param dto 用户扩展信息-邮储智慧校园
     * @return 影响行数
     */
    int update(EmsSnsShopUserExtDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}