package cn.com.duiba.quanyi.center.api.remoteservice.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.api.BatchGenerateUrlTaskDto;
import cn.com.duiba.quanyi.center.api.dto.qy.api.MultiChoiceOneOrderDto;
import cn.com.duiba.quanyi.center.api.param.api.MultiChoiceOneOrderSearchParam;
import java.util.List;

/**
 * API多选一订单表
 * @author kjj mybatis generator
 * @date 2025-05-13
 */
@AdvancedFeignClient
public interface RemoteMultiChoiceOneOrderService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return API多选一订单集合
     */
    List<MultiChoiceOneOrderDto> selectPage(MultiChoiceOneOrderSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(MultiChoiceOneOrderSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return API多选一订单
     */
    MultiChoiceOneOrderDto selectById(Long id);

    /**
     * 新增
     * @param dto API多选一订单
     * @return 执行结果
     */
    int insert(MultiChoiceOneOrderDto dto);

    /**
     * 更新
     * @param dto API多选一订单
     * @return 影响行数
     */
    int update(MultiChoiceOneOrderDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据主单号查询
     * @param mainOrderNum
     * @return
     */
    MultiChoiceOneOrderDto selectByMainOrderNum(String mainOrderNum);

    /**
     * 批量新增
     * @param list 批量生成短链
     * @return 执行结果
     */
    int batchInsert(List<MultiChoiceOneOrderDto> list);

    /**
     * 根据分页查询
     * @param thirdOrderId
     * @param pageSize
     * @param lastId
     * @return
     */
    List<MultiChoiceOneOrderDto> selectByThirdOrderIdOffset(String thirdOrderId, int pageSize, String lastId);

    /**
     * 根据批次ID查询最后一条记录
     * @param thirdOrderId
     * @return
     */
    MultiChoiceOneOrderDto selectLastRecordByBatchId(String thirdOrderId);

    /**
     * 根据批次ID查询生成记录数
     * @param thirdOrderId
     * @return
     */
    Long selectCountByBatchId(String thirdOrderId);
}
