package cn.com.duiba.quanyi.center.api.remoteservice.templatesconfig;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.templatesconfig.TemplatesConfigDto;
import cn.com.duiba.quanyi.center.api.dto.templatesconfig.TemplatesDetailDto;
import cn.com.duiba.quanyi.center.api.param.templatesconfig.TemplatesConfigSearchParam;
import java.util.List;

/**
 * 配置模版表
 * @author kjj mybatis generator 
 * @date 2024-12-02
 */
@AdvancedFeignClient
public interface RemoteTemplatesConfigService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 配置模版集合
     */
    List<TemplatesConfigDto> selectPage(TemplatesConfigSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(TemplatesConfigSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 配置模版
     */
    TemplatesConfigDto selectById(Long id);

    /**
     * 新增
     * @param dto 配置模版
     * @return 执行结果
     */
    int insert(TemplatesConfigDto dto);

    /**
     * 更新
     * @param dto 配置模版
     * @return 影响行数
     */
    int update(TemplatesConfigDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据模版id查询模版详情
     * @param templateId
     * @return
     */
    TemplatesDetailDto selectTemplatesDetailByTemplateId(Long templateId);

    /**
     * 根据唯一键查询json格式配置(带缓存)
     * @param unionKey
     * @return
     */
    String queryJsonStringByUk(String unionKey);
}