package cn.com.duiba.quanyi.center.api.dto.refund;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 退款定时扫描任务DTO
 *
 * @author yangyukang
 * @date 2025-01-21 15:30
 */
@Data
public class RefundScanTaskDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 业务类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.RefundBusinessTypeEnum
     */
    private Integer businessType;

    /**
     * 业务ID（唯一标识业务）
     */
    private Long businessId;

    /**
     * 任务状态(0 待执行 1执行中 2执行完成)
     * @see cn.com.duiba.quanyi.center.api.enums.RefundScanTaskStatusEnum
     */
    private Integer scanTaskStatus;

    /**
     * 失败文件路径
     */
    private String failFile;

    /**
     * 失败数量
     */
    private Integer failCount;
}
