package cn.com.duiba.quanyi.goods.service.api.enums.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/10/21 14:56
 */
@AllArgsConstructor
@Getter
public enum PurchaseSpuTypeEnum {
    OBJECT(1, "实物"),
    MOBILE_PAYMENT(2, "快捷支付"),
    ZC(3, "直充"),
    KA_MI(4, "卡密"),
    CAR_SER(5, "汽车服务"),
    ;
    
    private final Integer type;
    
    private final String desc;
    
    private static final Map<Integer, PurchaseSpuTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(PurchaseSpuTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * 
     * @param type 枚举值
     * @return 枚举
     */
    public static PurchaseSpuTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
    
}
