package cn.com.duiba.quanyi.goods.service.api.param.order;

import cn.com.duiba.quanyi.goods.service.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 订单表
 *
 * @author kjj mybatis generator
 * @date 2023-11-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class OrderSearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 17011668851615752L;

    /**
     * 唯一订单号
     */
    private String orderNo;

    /**
     * SPU id
     */
    private Long spuId;

    /**
     * SKU id
     */
    private Long skuId;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 客户订单号
     */
    private String customerOrderNo;

    /**
     * 订单状态
     * @deprecated 统一使用一个状态
     */
    @Deprecated
    private Integer orderStatus;

    /**
     * 商品发放状态
     * @see cn.com.duiba.quanyi.goods.service.api.enums.order.supplier.SupplierOrderStatusEnum
     */
    private Integer grantStatus;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 创建时间-开始时间
     */
    private Date createStartTime;

    /**
     * 创建时间-结束时间
     */
    private Date createEndTime;
}