package cn.com.duiba.quanyi.goods.service.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.goods.PurchaseSpuDto;
import cn.com.duiba.quanyi.goods.service.api.dto.goods.SpuDto;
import cn.com.duiba.quanyi.goods.service.api.dto.goods.SpuInfoDto;
import cn.com.duiba.quanyi.goods.service.api.param.goods.PurchaseSpuSearchParam;
import java.util.List;
import java.util.Set;

/**
 * 采购商品SPU表
 * @author kjj mybatis generator 
 * @date 2024-10-24
 */
@AdvancedFeignClient
public interface RemotePurchaseSpuService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 采购商品SPU集合
     */
    List<PurchaseSpuDto> selectPage(PurchaseSpuSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(PurchaseSpuSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 采购商品SPU
     */
    PurchaseSpuDto selectById(Long id);

    /**
     * 新增
     * @param dto 采购商品SPU
     * @return 影响行数
     */
    int insert(PurchaseSpuDto dto);

    /**
     * 更新
     * @param dto 采购商品SPU
     * @return 影响行数
     */
    int update(PurchaseSpuDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);

    /**
     * 根据主键批量查询
     *
     * @param ids 主键
     * @return SPU
     */
    List<PurchaseSpuDto> selectByIds(Set<Long> ids);

    /**
     * 新增或更新
     *
     * @param dto SPU详情
     * @return spu主键
     */
    Long saveOrUpdate(PurchaseSpuDto dto);

    /**
     * 获取规格ID
     * @return 规格ID
     */
    Long getAttrKey();

    /**
     * 获取子属性ID
     * @return 子属性ID
     */
    Long getAttrVal();

    /**
     * 变更状态
     * @param id 主键
     * @param fromStatus 原状态
     * @param toStatus 变更为
     * @see cn.com.duiba.quanyi.goods.service.api.enums.BooleanEnum
     * @return 影响行数
     */
    int changeStatus(Long id, Integer fromStatus, Integer toStatus);

}