package cn.com.duiba.quanyi.goods.service.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.goods.PurchaseSkuDto;
import cn.com.duiba.quanyi.goods.service.api.param.goods.PurchaseSkuSearchParam;
import java.util.List;

/**
 * 采购商品SKU表
 * @author kjj mybatis generator 
 * @date 2024-10-24
 */
@AdvancedFeignClient
public interface RemotePurchaseSkuService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 采购商品SKU集合
     */
    List<PurchaseSkuDto> selectPage(PurchaseSkuSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(PurchaseSkuSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 采购商品SKU
     */
    PurchaseSkuDto selectById(Long id);

    /**
     * 根据主键批量查询
     * @param ids
     * @return
     */
    List<PurchaseSkuDto> selectByIds(List<Long> ids);


    /**
     * 根据purchaseSpuId批量查询
     *
     * @param purchaseSpuIds spuId列表
     * @return sku列表
     */
    List<PurchaseSkuDto> selectByPurchaseSpuIds(List<Long> purchaseSpuIds);

    /**
     * 根据purchaseSpuId查询
     *
     * @param purchaseSpuId spuId
     * @return sku列表
     */
    PurchaseSkuDto selectByPurchaseSpuId(Long purchaseSpuId);

    /**
     * 新增
     * @param dto 采购商品SKU
     * @return 影响行数
     */
    Long insert(PurchaseSkuDto dto);

    /**
     * 更新
     * @param dto 采购商品SKU
     * @return 影响行数
     */
    int update(PurchaseSkuDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);
}