package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2024/5/20 19:47
 */
@Data
public class CloseReq implements Serializable {
    
    private static final long serialVersionUID = -165873835275521856L;

    /**
     * 获取商品类型
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 客户订单号
     */
    private String customerOrderNo;

    /**
     * 关单原因
     * 强制关闭订单时必填
     */
    private String closeReason;

    /**
     * 强制关闭订单：注意设置为true有超发风险
     * false-不确定状态会关闭失败
     * true-未成功的订单，都可以关闭掉，但是有可能导致超发（比如我们这边处理中，供应商后来成功了）
     */
    private boolean forceClose;
}
