package cn.com.duiba.quanyi.goods.service.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.goods.MchSkuRefDto;
import cn.com.duiba.quanyi.goods.service.api.param.goods.MchSkuRefSearchParam;
import java.util.List;

/**
 * 商户号与tb_sku关联表
 * @author kjj mybatis generator 
 * @date 2024-10-24
 */
@AdvancedFeignClient
public interface RemoteMchSkuRefService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 商户号与tb_sku关联集合
     */
    List<MchSkuRefDto> selectPage(MchSkuRefSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(MchSkuRefSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商户号与tb_sku关联
     */
    MchSkuRefDto selectById(Long id);

    /**
     * 新增
     * @param dto 商户号与tb_sku关联
     * @return 影响行数
     */
    int insert(MchSkuRefDto dto);

    /**
     * 更新
     * @param dto 商户号与tb_sku关联
     * @return 影响行数
     */
    int update(MchSkuRefDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);
}