package cn.com.duiba.quanyi.goods.service.api.dto.goods;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 采购商品SPU表
 * @author kjj mybatis generator 
 * @date 2024-10-24
 */
@Data
public class PurchaseSpuDto implements Serializable {
     
    private static final long serialVersionUID = 17297522632645397L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否已删除：0-未删除，1-已删除
     */
    private Integer logicDelete;

    /**
     * 商品名称
     */
    private String purchaseSpuName;

    /**
     * 商品类型，1-实物，2-快捷支付，3-直充，4-卡密，5-汽车服务
     */
    private Integer purchaseSpuType;

    /**
     * 商品备注
     */
    private String purchaseSpuRemark;

    /**
     * 商品主图链接，多张图用英文 逗号 分割
     */
    private String mainImgs;

    /**
     * 商品详情图链接，多张图用英文 逗号 分割
     */
    private String detailImgs;

    /**
     * 商品描述
     */
    private String purchaseSpuDesc;

    /**
     * 最低供货价，单位分，比如1元，数据存为100
     */
    private Integer minSupplyPrice;

    /**
     * 最高供货价，单位分，比如1元，数据存为100
     */
    private Integer maxSupplyPrice;

    /**
     * 最低指导价，单位分，比如1元，数据存为100
     */
    private Integer minMarketPrice;

    /**
     * 最高指导价，单位分，比如1元，数据存为100
     */
    private Integer maxMarketPrice;

    /**
     * 最低建议售价，单位分，比如1元，数据存为100
     */
    private Integer minSellPrice;

    /**
     * 最高建议售价，单位分，比如1元，数据存为100
     */
    private Integer maxSellPrice;

    /**
     * 商品状态：0-停用，1-启用
     */
    private Integer purchaseSpuStatus;

    /**
     * 面额类型，1-固定面额，2-自定义面额
     */
    private Integer amountType;

    /**
     * 费率
     */
    private Integer purchaseSpuRates;

    /**
     * 创建人ID
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 规格
     */
    private String attrList;
}