package cn.com.duiba.quanyi.goods.service.api.enums.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2023/12/1 14:51
 */
@Getter
@AllArgsConstructor
public enum CardSecretTypeEnum {

    CODE(1, "卡密-券码"),
    FIXED_LINK_CODE(2, "卡密-固定链接-兑换码"),
    FIXED_LINK(3, "卡密-链接券"),
    ACCOUNT(4, "卡密-账号-密码"),
    ;

    private final Integer type;

    private final String desc;

    private static final Map<Integer, CardSecretTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(CardSecretTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     *
     * @param type 枚举值
     * @return 枚举
     */
    public static CardSecretTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
