package cn.com.duiba.quanyi.goods.service.api.enums.subject;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: LuHui
 * @date: 2024/8/8 17:20
 * @description:
 */
@RequiredArgsConstructor
@Getter
public enum SubjectEnum {

    DUI_BA(1, "兑吧"),
    DUI_A(2, "兑啊"),
    DUI_JIE(3, "兑捷"),
    ;


    private final Integer type;

    private final String desc;

    private static final Map<Integer, SubjectEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SubjectEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     *
     * @param type 枚举值
     * @return 枚举
     */
    public static SubjectEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }


}
