package cn.com.duiba.quanyi.goods.service.api.dto.goods;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author nongfu
 * @Date 2024/10/26 10:54
 */
@Data
public class PurchaseSpuEsDto implements Serializable {

    private static final long serialVersionUID = -5635997460438435121L;

    /**
     * 主键ID
     * 采购spu 主键ID
     */
    private Long id;
    /**
     * 商品名称
     */
    private String purchaseSpuName;
    /**
     * 商品状态：0-停用，1-启用
     */
    private Integer purchaseSpuStatus;
    /**
     * 供应商ID
     */
    private List<Long> supplierIds;
    /**
     * 采购商品类型
     * 1 :OBJECT
     * 2 :MOBILE_PAYMENT
     * 3 :ZC
     * 4 :KA_MI
     * 5 :CAR_SER
     * 6 :ADVANCE_PAYMENT
     */
    private Integer purchaseSpuType;

    /**
     * 分类ID
     */
    private Integer goodsClassId;
    /**
     * 创建人ID
     */
    private Long createOperatorId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

}
