package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.telaidian;

import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.VirtualBaseOrderResult;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * TeLaiDianCouponZcOrderResult
 *
 * @author fmk
 * @since 2024/1/15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class TeLaiDianCouponZcOrderResult extends VirtualBaseOrderResult {

    /**
     * 订单内码
     */
    private String orderId;

    /**
     * 外部订单号
     */
    private String outOrderId;

    /**
     * 特来电订单状态<br>
     * 1 - 初始
     * 2 - 支付成功
     * 3 - 发券成功
     */
    private String customerOrderStatus;

    /**
     * 产品内码
     */
    private String productId;

    /**
     * 卡劵编号
     */
    private String ticketCode;

    /**
     * 卡劵状态<br>
     * 0 - 未激活
     * 1 - 已生效
     * 2 - 已使用
     * 3 - 已用完
     * 4 - 已作废
     *
     */
    private String ticketStatus;

    /**
     * 卡劵面值
     */
    private String ticketValue;

    /**
     * 剩余面值
     */
    private String ticketAvailableValue;

    /**
     * 有效开始时间
     */
    private String effDate;

    /**
     * 有效结束时间
     */
    private String expiryDate;

}
