package cn.com.duiba.quanyi.goods.service.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.goods.PurchaseGoodsClassDto;
import cn.com.duiba.quanyi.goods.service.api.param.goods.PurchaseGoodsClassSearchParam;
import java.util.List;

/**
 * 采购商品分类
 * @author kjj mybatis generator 
 * @date 2024-10-26
 */
@AdvancedFeignClient
public interface RemotePurchaseGoodsClassService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 采购商品分类集合
     */
    List<PurchaseGoodsClassDto> selectPage(PurchaseGoodsClassSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(PurchaseGoodsClassSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 采购商品分类
     */
    PurchaseGoodsClassDto selectById(Long id);

    /**
     * 新增
     * @param dto 采购商品分类
     * @return 影响行数
     */
    int insert(PurchaseGoodsClassDto dto);

    /**
     * 更新
     * @param dto 采购商品分类
     * @return 影响行数
     */
    int update(PurchaseGoodsClassDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);

    /**
     * 查询所有分类
     * @return 采购商品分类集合
     */
    List<PurchaseGoodsClassDto> all();

}