package cn.com.duiba.quanyi.goods.service.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.goods.SpuDto;
import cn.com.duiba.quanyi.goods.service.api.dto.goods.SpuInfoDto;
import cn.com.duiba.quanyi.goods.service.api.param.goods.SpuSearchEsParam;
import cn.com.duiba.quanyi.goods.service.api.param.goods.SpuSearchParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Set;

/**
 * SPU表
 *
 * @author kjj mybatis generator
 * @date 2023-11-20
 */
@AdvancedFeignClient
public interface RemoteSpuService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return SPU集合
     */
    List<SpuDto> selectPage(SpuSearchParam param);

    /**
     * 根据条件,查询记录的总记录数，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(SpuSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return SPU
     */
    SpuDto selectById(Long id);

    /**
     * 根据主键批量查询
     *
     * @param ids 主键
     * @return SPU
     */
    List<SpuDto> selectByIds(Set<Long> ids);

    /**
     * 新增或更新
     *
     * @param dto SPU详情
     * @return spu主键
     */
    Long saveOrUpdate(SpuInfoDto dto);

    /**
     * 获取规格ID
     * @return 规格ID
     */
    Long getAttrKey();

    /**
     * 获取子属性ID 
     * @return 子属性ID
     */
    Long getAttrVal();

    /**
     * 变更状态
     * @param id 主键
     * @param fromStatus 原状态
     * @param toStatus 变更为
     * @see cn.com.duiba.quanyi.goods.service.api.enums.BooleanEnum
     * @return 影响行数
     */
    int changeStatus(Long id, Integer fromStatus, Integer toStatus);

    /**
     * 软删
     *
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);

    /**
     * 通过采购商品ID和供应商ID查询
     * @param purchaseSpuId 采购spuId
     * @param supplierId  供应商id
     * @return spu
     */
    SpuDto selectByPurchaseSpuIdAndSupplierId(Long purchaseSpuId, Long supplierId);


    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return SPU集合
     */
    Pair<Long, List<SpuDto>> selectPageByEs(SpuSearchEsParam param);

    /**
     * 新增或更新
     * es
     * @param dto SPU详情
     * @return spu主键
     */
    Long saveOrUpdateByEs(SpuInfoDto dto);

    /**
     * 检查商品名称是否重复
     * @param spuType 商品类型
     * @param spuName 商品名称
     * @return 是否重复
     */
    Boolean checkGoodsNameRepeat(Integer spuType, String spuName);
}