package cn.com.duiba.quanyi.goods.service.api.enums.subject;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: LuHui
 * @date: 2024/8/8 17:20
 * @description:
 */
@RequiredArgsConstructor
@Getter
public enum SubjectEnum {

    DUI_BA(1, "杭州兑吧网络科技有限公司", "杭州兑吧"),
    DUI_A(2, "杭州兑啊网络科技有限公司", "杭州兑啊"),
    DUI_JIE(3, "兑捷", "兑捷"),
    FJ_DUI_TUI(4, "福建兑推网络科技有限公司", "福建兑推"),
    AH_CHUAN_SI(5, "安徽汌思信息科技有限公司", "安徽汌思"),
    AH_ZHI_YU(6, "安徽知予网络科技有限公司", "安徽知予"),
    SD_DUI_TUI(7, "山东兑推网络科技有限公司", "山东兑推"),
    FJ_DUI_BA(8, "福建兑吧网络科技有限公司", "福建兑吧"),
    AH_DUI_BA(9, "安徽兑吧网络科技有限公司", "安徽兑吧"),
    DUIBA_TONG_LING(10, "杭州兑吧网络科技有限公司铜陵分公司", "兑吧铜陵分"),
    FJ_DUI_A(11, "福建兑啊网络科技有限公司", "福建兑啊"),
    HZ_MEI_REN(12, "杭州美韧网络科技有限公司", "杭州美韧"),
    HZ_SHEN_TONG(13, "杭州神同网络科技有限公司", "杭州神同"),
    ;


    private final Integer type;

    private final String desc;
    
    private final String abbreviation;

    private static final Map<Integer, SubjectEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SubjectEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     *
     * @param type 枚举值
     * @return 枚举
     */
    public static SubjectEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }


}
