package cn.com.duiba.quanyi.goods.service.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.goods.SkuDto;

import java.util.List;

/**
 * SKU表
 *
 * @author kjj mybatis generator
 * @date 2023-11-22
 */
@AdvancedFeignClient
public interface RemoteSkuService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return SKU
     */
    SkuDto selectById(Long id);

    /**
     * 根据主键批量查询
     *
     * @param ids 主键列表
     * @return SKU列表
     */
    List<SkuDto> selectByIds(List<Long> ids);

    /**
     * 根据spuId批量查询
     *
     * @param spuIds spuId列表
     * @return sku列表
     */
    List<SkuDto> selectBySpuIds(List<Long> spuIds);

    /**
     * 根据spuId查询
     *
     * @param spuId spuId
     * @return sku列表
     */
    List<SkuDto> selectBySpuId(Long spuId);

    /**
     * 软删
     *
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);


    /**
     * 通过采购skuID 和供应商ID查询 (已删除也会查出来)
     * @param purchaseSkuId 采购skuId
     * @param purchaseSpuId 采购spuId
     * @param supplierId 供应商id
     * @return sku
     */
    SkuDto selectByPurchaseIdAndSupplierId(Long purchaseSpuId,Long purchaseSkuId, Long supplierId);
    
    /**
     * 根据采购商品skuId查询
     * @param purchaseSkuId 采购skuId
     * @return sku列表
     */
    List<SkuDto> selectCanUseByPurchaseSkuId(Long purchaseSkuId);
}