package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.naixue;

import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.VirtualBaseOrderResult;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @author: LuHui
 * @date: 2024/2/20 14:59
 * @description:
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class NaiXueZcOrderResult extends VirtualBaseOrderResult {
    private static final long serialVersionUID = 2397284512937230446L;

    /**
     * 优惠券券码列表
     */
    private List<String> couponCodeList;
    /**
     * 优惠券详情列表
     */
    private List<CouponInfo> couponInfoList;


    @Data
    public static class CouponInfo implements Serializable {

        private static final long serialVersionUID = -3423442002807171954L;
        /**
         * 优惠券券码
         */
        private String couponCode;
        /**
         * 优惠券生效开始时间 格式： yyyy-MM-dd HH:mm:ss
         */
        private String validStart;
        /**
         * 优惠券生效结束时间 格式： yyyy-MM-dd HH:mm:ss
         */
        private String validEnds;
    }
}
