package cn.com.duiba.quanyi.goods.service.api.param.goods;

import cn.com.duiba.quanyi.goods.service.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * SPU表
 *
 * @author kjj mybatis generator
 * @date 2023-11-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SpuSearchEsParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 17004797934078932L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 分类ID
     */
    private Long goodsClassId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 商品类型，1-实物，2-微信立减金
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 商品状态：0-停用，1-启用
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuStatusEnum
     */
    private Integer spuStatus;

    /**
     * 创建人ID
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 开始时间
     */
    private Date startTime;
    /**
     * 结束时间
     */
    private Date endTime;

}