package cn.com.duiba.quanyi.goods.service.api.param.cardsecret;

import java.util.Date;
import java.util.List;

import cn.com.duiba.quanyi.goods.service.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 卡密关联退回记录查询参数
 *
 * @author yangyukang
 * @date 2024-01-15
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CardSecretAssociationReturnedRecordQueryParam extends PageQuery {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 卡密关联记录Id
     */
    private Long cardSecretAssociationTaskId;

    /**
     * 上传任务ID
     */
    private Long taskId;

    /**
     * 批次号
     */
    private Long cardSecretBatchId;

    /**
     * 操作人ID
     */
    private Long operatorId;

    /**
     * 操作人名称
     */
    private String operatorName;

    /**
     * 状态
     * @see cn.com.duiba.quanyi.goods.service.api.enums.cardsecret.ReturnedRecordStatusEnum
     */
    private Integer status;

    /**
     * 创建时间-开始
     */
    private Date createTimeStart;

    /**
     * 创建时间-结束
     */
    private Date createTimeEnd;

    /**
     * 关联任务ID列表
     */
    private List<Long> cardSecretAssociationTaskIds;

    /**
     * 批次ID列表
     */
    private List<Long> cardSecretBatchIds;

    /**
     * 操作人ID列表
     */
    private List<Long> operatorIds;

    /**
     * 状态列表
     */
    private List<Integer> statusList;

}
