package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretBatchExtDto;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.CardSecretBatchExtSearchParam;
import java.util.List;
import java.util.Map;

/**
 * 卡密配置拓展表
 * @author kjj mybatis generator 
 * @date 2024-10-26
 */
@AdvancedFeignClient
public interface RemoteCardSecretBatchExtService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 卡密配置拓展集合
     */
    List<CardSecretBatchExtDto> selectPage(CardSecretBatchExtSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CardSecretBatchExtSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 卡密配置拓展
     */
    CardSecretBatchExtDto selectById(Long id);

    /**
     * 新增
     * @param dto 卡密配置拓展
     * @return 影响行数
     */
    int insert(CardSecretBatchExtDto dto);

    /**
     * 更新
     * @param dto 卡密配置拓展
     * @return 影响行数
     */
    int update(CardSecretBatchExtDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);


    /**
     * 物理删除 根据批次id
     * @param batchId 主键
     * @return 影响行数
     */
    int deleteByBatchId(Long batchId);


    /**
     * 批量新增或更新
     *
     * @param batchId  卡密主键id
     * @param extMap 扩展信息
      * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.CardSecretExtConfNameEnum
     * @return 影响行数
     */
    int batchInsertOrUpdate(Long batchId, Map<Integer, String> extMap);

    /**
     * 根据批次ID 批量查询
     * @return 影响行数
     */
    List<CardSecretBatchExtDto>  selectByBatchId(Long batchId);
}