package cn.com.duiba.quanyi.goods.service.api.dto.cardsecret;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 卡密入库单
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@Data
public class CardSecretInboundOrderDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.goods.service.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 上传任务ID
     */
    private Long taskId;

    /**
     * 采购单ID
     */
    private Long purchaseOrderId;

    /**
     * 采购商品spuId
     */
    private Long purchaseSpuId;

    /**
     * 采购商品skuId
     */
    private Long purchaseSkuId;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 采购单创建时间
     */
    private Date purchaseOrderCreate;

    /**
     * 成本价
     */
    private Integer costPrice;

    /**
     * 已入库数量
     */
    private Long receivedQty;

    /**
     * 退回数量
     */
    private Long returnedQty;


    /**
     * 已关联数量
     */
    private Long linkedQty;

    /**
     * 总金额
     */
    private Long totalAmount;

    /**
     * 申请付款金额
     */
    private Long applyPaymentAmount;

    /**
     * 实际付款金额
     */
    private Long actualPaymentAmount;

}
