package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.supplier;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.supplier.SupplierOrderMeiTuanCouponDto;
import cn.com.duiba.quanyi.goods.service.api.param.order.supplier.SupplierOrderMeiTuanCouponSearchParam;
import java.util.List;

/**
 * 供应商订单-美团支付劵扩展字段
 * @author kjj mybatis generator 
 * @date 2024-09-19
 */
@AdvancedFeignClient
public interface RemoteSupplierOrderMeiTuanCouponService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 供应商订单-美团支付劵扩展字段集合
     */
    List<SupplierOrderMeiTuanCouponDto> selectPage(SupplierOrderMeiTuanCouponSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(SupplierOrderMeiTuanCouponSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 供应商订单-美团支付劵扩展字段
     */
    SupplierOrderMeiTuanCouponDto selectById(Long id);

    /**
     * 新增
     * @param dto 供应商订单-美团支付劵扩展字段
     * @return 影响行数
     */
    int insert(SupplierOrderMeiTuanCouponDto dto);

    /**
     * 更新
     * @param dto 供应商订单-美团支付劵扩展字段
     * @return 影响行数
     */
    int update(SupplierOrderMeiTuanCouponDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);
}