package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.wx;

import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.VirtualBaseOrderResult;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * 微信红包
 *
 * @author wangguanhua
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class WxRedPacketOrderResult extends VirtualBaseOrderResult {

    private static final long serialVersionUID = -1650417496084917285L;

    /**
     * 最后一次状态变更的时间(当成功时为完成时间)
     */
    private Long updateTime;

    /**
     * 红包领取时间
     */
    private Date receiveTime;

    /**
     * 红包金额
     */
    private Long amount;

    /**
     * 退款时间
     */
    private Date refundTime;

    /**
     * 交易流水号
     */
    private String transactionId;

}
