package cn.com.duiba.quanyi.goods.service.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.goods.MchSkuRefDto;

/**
 * 商户号与tb_sku关联表
 * @author kjj mybatis generator 
 * @date 2024-10-24
 */
@AdvancedFeignClient
public interface RemoteMchSkuRefService {

    /**
     * 根据唯一约束查询
     * @param mchId 商户号
     * @param spuType 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     * @return 商户号与tb_sku关联
     */
    MchSkuRefDto selectByUk(String mchId, Integer spuType);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商户号与tb_sku关联
     */
    MchSkuRefDto selectById(Long id);

    /**
     * 新增
     * @param dto 商户号与tb_sku关联
     * @return 影响行数
     */
    int insert(MchSkuRefDto dto);

    /**
     * 更新
     * @param dto 商户号与tb_sku关联
     * @return 影响行数
     */
    int update(MchSkuRefDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);
}