package cn.com.duiba.quanyi.goods.service.api.param.cardsecret;

import cn.com.duiba.quanyi.goods.service.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * 卡密入库单分页查询参数
 *
 * @author xuzhigang
 * @date 2025-09-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class CardSecretInboundOrderSearchParam extends PageQuery {

    private static final long serialVersionUID = -4217248333668725127L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 主键列表
     */
    private List<Long> ids;

    /**
     * 上传任务ID
     */
    private Long taskId;

    /**
     * 采购单ID
     */
    private Long purchaseOrderId;

    /**
     * 采购商品spuId
     */
    private Long purchaseSpuId;

    /**
     * 采购商品skuId
     */
    private Long purchaseSkuId;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 创建时间-开始时间
     */
    private Date gmtCreateStart;

    /**
     * 创建时间-结束时间
     */
    private Date gmtCreateEnd;

    /**
     * 采购单创建时间-开始时间
     */
    private Date purchaseOrderCreateStart;

    /**
     * 采购单创建时间-结束时间
     */
    private Date purchaseOrderCreateEnd;

    /**
     * 是否入库
     * @see cn.com.duiba.quanyi.goods.service.api.enums.BooleanEnum
     */
    private Integer isInbound;
}
