package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.alipay.transfer;

import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateExtReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 支付宝单笔转账
 * @author lizhi
 * @date 2024/1/19 18:27
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class AlipayTransferCreateReq extends BaseOrderCreateExtReq {
    
    private static final long serialVersionUID = -4579056338049266054L;

    /**
     * 转账金额，单位：分
     * 必填
     */
    private Long amount;

    /**
     * 转账业务的标题，用于在支付宝用户的账单里显示
     * 必填
     */
    private String orderTitle;

    /**
     * 标识
     * identity_type=BANKCARD_ACCOUNT时，填写收款方银行卡号;
     * identity_type=ALIPAY_USER_ID 时，填写支付宝用户UID;
     * identity_type=ALIPAY_LOGON_ID 时，填写支付宝登录号;
     * 必填
     */
    private String identity;

    /**
     * 标识类型
     * BANKCARD_ACCOUNT：收款方银行卡号
     * ALIPAY_USER_ID：支付宝会员的用户 ID，可通过 获取会员信息 能力获取。
     * ALIPAY_LOGON_ID：支付宝登录号，支持邮箱和手机号格式。
     * 必填
     * @see cn.com.duiba.quanyi.goods.service.api.enums.order.supplier.AlipayTransferIdentityTypeEnum
     */
    private String identityType;

    /**
     * 收款方银行账户名称
     * (选填，identity_type=ALIPAY_LOGON_ID/BANKCARD_ACCOUNT 时，本字段必填)
     */
    private String realName;

    /**
     * 业务备注
     * 选填
     */
    private String remark;
}
