package cn.com.duiba.quanyi.goods.service.api.enums.cardsecret;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 入库状态枚举
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@Getter
@AllArgsConstructor
public enum ReceivingStatusEnum {
    PENDING(1, "待入库"),
    PARTIAL(2, "部分入库"),
    COMPLETED(3, "入库"),
    ;

    private final Integer code;
    private final String desc;

    public static ReceivingStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (ReceivingStatusEnum statusEnum : values()) {
            if (statusEnum.getCode().equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }
}
