package cn.com.duiba.quanyi.goods.service.api.dto.supplier;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 银联券回调记录表
 * @author kjj mybatis generator 
 * @date 2025-04-21
 */
@Data
public class SupplierOrderUnionPayCouponCallbackDto implements Serializable {
     
    private static final long serialVersionUID = 1745222140257280L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 客户订单号
     */
    private String customerOrderNo;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 优惠券ID（回调为couponId）
     */
    private String discountId;

    /**
     * 发放数量（couponNum）
     */
    private Integer discountNum;

    /**
     * 操作类型 01：优惠券承兑 02：优惠券返还 03：优惠券无操作 04：优惠券获取 05：优惠券删除 06：优惠券过期
     */
    private String operTp;

    /**
     * 卷码id
     */
    private String couponId;

    /**
     * 订单金额
     */
    private Long orderAmount;

    /**
     * 优惠金额
     */
    private Long discountAmount;

    /**
     * 操作类型 仅在operTp为01、02、03时出现，取值为01消费，31撤销，04退货
     */
    private String transTp;

    /**
     * 通知流水号
     */
    private String transSeq;

    /**
     * 变更时间 格式：yyyy-MM-dd HH:mm:ss
     */
    private Date transTime;

    /**
     * 回调信息json
     */
    private String callbackInfo;
}