package cn.com.duiba.quanyi.goods.service.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2023/12/27 17:53
 */
@Getter
@AllArgsConstructor
public enum AlipayCouponCallbackEventTypeEnum {
    //券发放(V_BATCH_PUBLISH)、券过期(V_EXPIRE)，券删除(V_DELETE)、券核销（V_USE）、券退款（V_REFUND）
    V_BATCH_PUBLISH("券发放"),
    V_EXPIRE("券过期"),
    V_DELETE("券删除"),
    V_USE("券核销"),
    V_REFUND("券退款"),
    ;
    
    private final String desc;
    
    private static final Map<String, AlipayCouponCallbackEventTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(Enum::name, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举名称获取枚举
     * @param name 枚举名称
     * @return 枚举
     */
    public static AlipayCouponCallbackEventTypeEnum getByName(String name) {
        if (name == null) {
            return null;
        }
        return ENUM_MAP.get(name);
    }
}
