package cn.com.duiba.quanyi.goods.service.api.enums.cardsecret;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 关联任务状态枚举
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@Getter
@AllArgsConstructor
public enum AssociationTaskStatusEnum {
    ASSOCIATING(1, "关联中"),
    ASSOCIATED(2, "已关联"),
    RETURNED(3, "已退回"),
    PARTIAL_RETURNED(4, "部分退回"),
    ;

    private final Integer code;
    private final String desc;

    public static AssociationTaskStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (AssociationTaskStatusEnum statusEnum : values()) {
            if (statusEnum.getCode().equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }
}
