package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.processor.virtual;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.chabaidao.ChaBaiDaoZcOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderCreateResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.chabaidao.ChaBaiDaoZcOrderResult;

/**
 * 茶百道远程服务接口
 *
 * @author yangyk
 * @since 2025/1/30
 */
@AdvancedFeignClient
public interface RemoteOrderProcessorChaBaiDaoService {

    /**
     * 下单
     *
     * @param dto 下单所需参数
     * @return 下单结果
     */
    OrderCreateResult create(BaseOrderCreateReq<ChaBaiDaoZcOrderCreateReq> dto);

    /**
     * 查询订单结果
     *
     * @param customerOrderNo 客户订单号
     * @return 订单结果
     */
    ChaBaiDaoZcOrderResult findOrderResult(String customerOrderNo);
} 