package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretInboundOrderDto;

/**
 * 卡密入库单远程服务
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@AdvancedFeignClient
public interface RemoteCardSecretInboundOrderService {

    /**
     * 更新
     *
     * @param dto 参数dto
     * @return 影响行数
     */
    int update(CardSecretInboundOrderDto dto);

    /**
     * 保存
     *
     * @param dto 参数dto
     * @return 影响行数
     */
    Long insert(CardSecretInboundOrderDto dto);

    /**
     * 根据主键ID查询
     *
     * @param id 主键ID
     * @return CardSecretInboundOrderDto
     */
    CardSecretInboundOrderDto selectById(Long id);

    /**
     * 删除
     *
     * @param id 主键ID
     * @return 影响行数
     */
    int delete(Long id);

    /**
     * 根据采购单ID查询
     *
     * @param purchaseOrderId 采购单ID
     * @return 入库单列表
     */
    List<CardSecretInboundOrderDto> selectByPurchaseOrderId(Long purchaseOrderId);

    /**
     * 根据任务ID查询
     *
     * @param taskId 任务ID
     * @return 入库单列表
     */
    List<CardSecretInboundOrderDto> selectByTaskId(Long taskId);

    /**
     * 根据供应商ID查询
     *
     * @param supplierId 供应商ID
     * @return 入库单列表
     */
    List<CardSecretInboundOrderDto> selectBySupplierId(Long supplierId);

}

