package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.supplier.callback;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.supplier.SupplierOrderUnionPayCouponCallbackDto;
import cn.com.duiba.quanyi.goods.service.api.param.supplier.SupplierOrderUnionPayCouponCallbackSearchParam;
import java.util.List;

/**
 * 银联券回调记录表
 * @author kjj mybatis generator 
 * @date 2025-04-21
 */
@AdvancedFeignClient
public interface RemoteSupplierOrderUnionPayCouponCallbackService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 银联券回调记录集合
     */
    List<SupplierOrderUnionPayCouponCallbackDto> selectPage(SupplierOrderUnionPayCouponCallbackSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(SupplierOrderUnionPayCouponCallbackSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 银联券回调记录
     */
    SupplierOrderUnionPayCouponCallbackDto selectById(Long id);

    /**
     * 新增
     * @param dto 银联券回调记录
     * @return 影响行数
     */
    int insert(SupplierOrderUnionPayCouponCallbackDto dto);

    /**
     * 更新
     * @param dto 银联券回调记录
     * @return 影响行数
     */
    int update(SupplierOrderUnionPayCouponCallbackDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);
}