package cn.com.duiba.quanyi.goods.service.api.enums.cardsecret;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 批次类型枚举
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@Getter
@AllArgsConstructor
public enum BatchTypeEnum {
    OLD_BATCH(1, "旧批次"),
    ONLINE_BATCH(2, "线上批次"),
    OFFLINE_BATCH(3, "线下批次"),
    PURCHASE_ORDER(4, "采购单"),
    ;

    private final Integer code;
    private final String desc;

    public static BatchTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (BatchTypeEnum typeEnum : values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }
}
