package cn.com.duiba.quanyi.goods.service.api.dto.order.supplier;

import cn.com.duiba.quanyi.goods.service.api.enums.order.supplier.SupplierOrderStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xuzhigang
 * @date 2024/7/11 16:57
 **/
@Data
public class SupplierOrderWxRedPacketDto implements Serializable {
    private static final long serialVersionUID = 7772519044547440275L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 客户订单号
     */
    private String customerOrderNo;

    /**
     * 公众账号ID
     */
    private String appId;

    /**
     * openId
     */
    private String openId;

    /**
     * 红包金额，单位：分
     */
    private Long amount;

    /**
     * 微信红包的活动名称
     */
    private String remark;

    /**
     * 商户名称，红包发送者名称
     */
    private String sendName;

    /**
     * 红包祝福语
     */
    private String wishing;

    /**
     * 最后一次状态变更的时间
     */
    private Date updateTime;

    /**
     * 子订单号
     */
    private String subOrderNo;

    /**
     * 供应商api标识码
     */
    private String supplierApiCode;

    /**
     * SPU id
     */
    private Long spuId;

    /**
     * SKU id
     */
    private Long skuId;

    /**
     * 发放时间
     */
    private Date grantTime;

    /**
     * 发放虚拟商品所需信息
     */
    private String accountInfo;

    /**
     * 虚拟商品发放状态
     *
     * @see SupplierOrderStatusEnum#getCode()
     */
    private Integer grantStatus;

    /**
     * 供应商返回的唯一流水号
     */
    private String supplierBizNo;

    /**
     * 供应商错误信息
     */
    private String errMsg;

    /**
     * 关单原因
     */
    private String closeReason;

    /**
     * 发放结果json
     */
    private String grantResult;
}
