/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.goods.service.api.enums.express;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ExpressTrackStatusEnum {
    NO_INFO(-1, "\u6682\u65e0\u7269\u6d41\u8f68\u8ff9\u4fe1\u606f"),
    IN_TRANSIT(0, "\u5728\u9014"),
    PICK_UP(1, "\u63fd\u6536"),
    DIFFICULT(2, "\u7591\u96be"),
    RECEIVED(3, "\u7b7e\u6536"),
    SIGN_OUT(4, "\u9000\u7b7e"),
    DELIVERY(5, "\u6d3e\u4ef6"),
    REFUND(6, "\u9000\u56de"),
    SWITCH(7, "\u8f6c\u6295");

    private final Integer status;
    private final String desc;
    private static final Map<Integer, ExpressTrackStatusEnum> ENUM_MAP;

    public static ExpressTrackStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    private ExpressTrackStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(ExpressTrackStatusEnum.values()).collect(Collectors.toMap(ExpressTrackStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));
    }
}

