package cn.com.duiba.quanyi.goods.service.api.param.cardsecret;

import java.io.Serializable;

import lombok.Data;

/**
 * 卡密关联退回记录更新参数
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@Data
public class CardSecretAssociationReturnedRecordUpdateParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 要退回的数量
     */
    private Long toReturnQty;

    /**
     * 原状态
     */
    private Integer fromStatus;

    /**
     * 目标状态
     */
    private Integer toStatus;

    /**
     * 验证参数有效性
     *
     * @return 是否有效
     */
    public boolean isValid() {
        return id != null && id > 0
                && toReturnQty != null && toReturnQty >= 0
                && fromStatus != null
                && toStatus != null;
    }
}
